#ifndef _SPIDEV_H
#define _SPIDEV_H

typedef struct {
    uint8_t mode;
    uint8_t bits_per_word;
    uint32_t speed;
    uint16_t delay;
} spidev_cfg_t;

class SpiDev {
   private:
      char * _devName;
      int _fd;
      spidev_cfg_t _cfg;
      bool _isOpen;
   public:
      SpiDev(const char * devName);
      SpiDev(const char * devName, spidev_cfg_t * cfg);
      ~SpiDev();
      bool begin();
      bool end();
      int read(uint8_t *rxBuf,uint8_t rxLen);
      int write(uint8_t *txBuf,uint8_t txLen);
      int xfer(uint8_t *txBuf, uint8_t txLen, uint8_t *rxBuf, uint8_t rxLen);
      bool setSpeed(uint32_t speed);
      bool setMode(uint8_t mode);
      bool setBitPerWord(uint8_t nbBits);
      bool setConfig(spidev_cfg_t *cfg);
};
#endif 

