// === mainui.h ===
#ifndef MAINUI_H
#define MAINUI_H

#include <QDialog>
#include <QCloseEvent>
#include <QtCharts/QChartView>
#include <QtCharts/QLineSeries>
QT_CHARTS_USE_NAMESPACE



namespace Ui {
class MainUI;
}

class MainUI : public QDialog
{
    Q_OBJECT

public:
    explicit MainUI(QWidget *parent = nullptr);
    ~MainUI();
    void setFileNameLabel(const QString &fileName);
    QChartView* getChartView() const;

protected:
    void closeEvent(QCloseEvent *event) override {
        event->ignore();
    }

private:
    Ui::MainUI *ui;

private slots:
    void onBtnSimuToggled(bool checked);
    void onBtnQuitClicked();

signals:
    void simuToggled(bool checked);
    void openFileRequested();
    void exitRequested();
};

#endif // MAINUI_H
