// === mainui.cpp ===
#include <QMessageBox>
#include <QFileInfo>
#include "mainui.h"
#include "ui_mainui.h"

MainUI::MainUI(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::MainUI)
{
    setWindowFlags(Qt::Window | Qt::FramelessWindowHint);
    ui->setupUi(this);
    ui->fileLabel->setText("Aucun fichier sélectionné.");

    connect(ui->btnSimu, &QPushButton::toggled, this, &MainUI::onBtnSimuToggled);
    connect(ui->btnQuit, &QPushButton::clicked, this, &MainUI::onBtnQuitClicked);
    connect(ui->openFileButton, &QPushButton::clicked, this, &MainUI::openFileRequested);
}

MainUI::~MainUI()
{
    delete ui;
}

void MainUI::onBtnSimuToggled(bool checked)
{
    if (checked) {
        ui->btnSimu->setText("Stopper la simulation");
        ui->btnQuit->setEnabled(false);
    } else {
        ui->btnSimu->setText("Lancer la simulation");
        ui->btnQuit->setEnabled(true);
    }
    emit simuToggled(checked);
}

void MainUI::onBtnQuitClicked()
{
    emit exitRequested();
}

void MainUI::setFileNameLabel(const QString &fileName)
{
    if (fileName.isEmpty()) {
        ui->fileLabel->setText("Aucun fichier sélectionné.");
    } else {
        ui->fileLabel->setText(QFileInfo(fileName).fileName());
    }
}

QChartView* MainUI::getChartView() const{
    return ui->chartView;
}
