// === appworker.h ===
#ifndef APPWORKER_H
#define APPWORKER_H

#include <QObject>
#include <QTimer>
#include <QMutex>
#include <QWaitCondition>
#include <QVector>

#include "spidev.h"

class AppWorker : public QObject
{
    Q_OBJECT
public:
    explicit AppWorker(QObject *parent = nullptr);
    ~AppWorker();
    void doWork();
    void suspend();
    void resume();
    void quit();
    void setDataFile(QString fileName);

private:
    SpiDev * _dac8551;
    bool _quit;
    bool _suspend;
    QMutex _mutex;
    QWaitCondition _waitCondition;
    QVector<int> _data;

signals:
    void finished();
    void resultReady(const QString &result);
};

#endif // APPWORKER_H
