// app.h
#ifndef APP_H
#define APP_H

#include <QObject>
#include <QThread>
#include "mainui.h"
#include "appworker.h"

class App : public QObject
{
    Q_OBJECT
public:
    explicit App(QObject *parent = nullptr);
    ~App();
    void run();

private:
    MainUI *_ihm;
    QThread *_workerThread;
    AppWorker *_worker;
    QString _selectedFile;

private slots:
    void onSimuToggled(bool checked);
    void onExitRequested();
    void onOpenFileClicked();
};

#endif // APP_H
